<!DOCTYPE html>
<html>

% include('header_intro.tpl', title='Information about the study', parameter = para)


<body>
    <div class="container">
		<h1>About the study</h1>

		<article>
			<p><span class="red">Warning!</span> 
				This study is designed to be interacted with a mouse or keyboard. If you are using a touch device for input you might not be credited the reward!
			</p>
			<h2>Intro</h2> 
			<p>
				This study intends to measure the perception of differences in the design of lettershapes. Some of these differences can be classified as design parameters. You will be asked to judge where a stimulus is placed between two endpoints of a design-space. One of these parameters is {{ para }}
			</p>
		</article>

		<article>
			<h2>About {{ para }}</h2>
			<p>{{ para_info }}</p>
			<figure>
			<img src="/assets/imgs/info_gifs/{{ para }}.gif" alt="An interpolation of the {{ para }} parameter"> 
			<figcaption>An interpolation between the two endpoints</figcaption>
			<img src="/assets/imgs/overlays/{{ para }}_overlay.png" alt="Left and right endpoints overlapped">
			<figcaption>Left and right endpoints overlapping in the center</figcaption>
			%if  para =="xHeight":
				<img src="/assets/imgs/overlays/xHeight-info.gif" alt="xHeight info">
				<figcaption>The x-height in comparison to other horizontal guides.</figcaption>
			%end
			</figure>
		</article>

		<article>
			<h2>The trial setup</h2>
			<img src="/assets/imgs/explain_img.jpg" alt="An example for a trial"> 
			<p>You will be presented a horizontal slider <span class="red">❶</span> and a knob <span class="red">❷</span>. Initially the knob will be placed at a random position on the slider. There will be two words below the slider at each end (<span class="red">❸</span> and <span class="red">❹</span>). They define the axis of the parameter and the third word <span class="red">❺</span> above the slider has to be judged. <br>
			The task of the study is to adjust the slider to define where the visual appearance of the top word lies in between the two lower words. </p>
			
			<p>The three words are randomly selected english words. Their meaning or combination is irrelevant since they are just used to visualise the design. The important part is how they look.</p>
			<img src="/assets/imgs/range_input.gif" alt="Interact with the slider">
			<p>You can adjust the slider either by using the mouse and just click and drag the knob or by using the keyboard's arrow keys. Pressing the left or right key will change the slider for one unit, hitting the left or right key in combination with the shift key will change the knob by ten units. </p>
			<p>Once you are happy with setting of the slider click the <span class='letter_spaced'>OK</span> button or hit the return key on your keyboard. You have to change the slider to enable the <span class='letter_spaced'>OK</span> button. After you submitted your input you will be taken to the next trial. Repeat the described procedure until you get to the finish page.</p>
		</article>

        <h2>Example</h2>
        <p>You can test the keyboard or mouse input and trial setup on the example below.</p>

		<form action="./tryajax" method="POST" id="the_form">
	    	<formfield>          
	    	<p class="stimuli center target" id='C'>reading</p>
			<input id="nextButton" class="center" type="submit" value="OK" disabled>
          	<input name='user_input' class="input-range" type="range" id="set_value" min="0" max="100" value= "50" step="1" />
			% if para == 'aperture':
				<p class="stimuli B range-label">personal</p>
				<p class="stimuli A range-label">pendulum</p>
			% else:
				<p class="stimuli A range-label">personal</p>
				<p class="stimuli B range-label">pendulum</p>
				%end
	    </formfield>
		</form>

		<p>If you are ready to start the study press the <span class='letter_spaced'>START</span> button below.<br>
		<p>Please be accurate!</p>
    	<p><form action="./round1"><input type="submit" value="S T A R T"></form></p>

    </div>
    <script>
    var url_part = { exp: {{!'"%s"' % exp }}, para: {{!'"%s"' % para }} };
    </script>
    <script src='/assets/js/jquery-1.11.3.min.js'></script>
    <script src="/assets/js/slider_intro.js"></script>
    <script src="/assets/js/ok_placing.js"></script>

  

% include('footer.tpl')

</body>
</html>
